<% option explicit 
	Response.Expires = -1
	Response.Buffer = true
%>
<!-- #include file="inc/common.asp" -->
<!-- #include file="inc/consts.asp" -->
<!-- #include file="inc/lib.asp" -->
<html>
<head>
<title>Monitoring</title>
<% 
Dim oInstDb, oServer, strStatus, strServer, strServerName, strRefInterval, flSesTerm
Dim flSaveBtn, oINIFile, oSection, iInt, flSave, strServerURL, strServerNameURL, flRunning
Dim flSrvRemoved, strWebSrv, strWebSrvPort

dim strWebVersion

AppSessionID = Application("SessionID")
flSesTerm = (Session.SessionID <> AppSessionID and AppSessionID<>0)

strServer = Request.QueryString("server")

strServerURL = Server.URLEncode(strServer)

on error resume next 
flRunning = IsServerRunning(strServer, oServer)
if Err.number<>0 then
	flRunning = false
	flSrvRemoved = true
else 
	flSrvRemoved = false	
end if
on error goto 0

Dim flMonitoringEnabled
flMonitoringEnabled = IsFlagValueON( GetINIValue( oServer.Location & "/casp.cnfg", "default machine", "enablemonitoring", "0", true ) )

'Set oInstDb = CreateObject("chili.installed_db")
'Set oServer=oInstDb.Servers(strServer)
if (not flSrvRemoved) then
	strServerName = oServer.ServerName
	strServerNameURL = Server.URLEncode(strServerName)

	strWebVersion = oServer.WebVersion

	strWebSrv = oServer.ServerURL
	strWebSrvPort = WebServerPort(strWebSrv)
	strWebSrv = WebServerName(strWebSrv)

	Set oINIFile = CreateObject("chili.inifile")
	oINIFile.Open (oServer.Location & "/casp.cnfg")
	Set oSection = oINIFile.Sections("admin")

	on error resume next
	if not flSaveBtn Then
		strRefInterval = oSection.Items("monitoring_refresh")
	end if
	iInt = CLng(strRefInterval)
	if Err.number<>0 Then
		strRefInterval = "10"
		flSave=true
	end if
	iInt = Abs(Int(iInt))
	If iInt<2 Then
		iInt = 2
	end if
	strRefInterval = CStr(iInt)
	on error goto 0
end if

if not Request.QueryString("c")="1" then
	Response.Write "<meta http-equiv=""Refresh"" Content="""
	if (flRunning and (not flSesTerm)) then 
		Response.Write strRefInterval
	else
		Response.Write "10"
	end if
	Response.Write """>"
end if 
%>
<link rel="stylesheet" type="text/css" href="css/main.css">
</head>

<body bgcolor="#FFFFFF" topmargin="0" leftmargin="0" link="#FFFFFF" vlink="#FFFFFF" alink="#FFFFFF">

<div align="left">
  <table border="0" width="500" height="10">
    <tr>
      <td width="10"></td>
      <td width="480"><br><% 
   WriteTextFont "Live Monitoring", "", "4", ""
   if( IsMultiserversAllow )Then
		WriteFont "", "3", ""
		Response.Write "<br>"
		Response.Write TranslateText("ASP server") & ": <font color=""#777777"">" & strServerName & "</font><br>"
		Response.Write TranslateText("Web server") & ": <font color=""#777777"">" & strWebSrv & "</font> port: <font color=""#777777"">" & strWebSrvPort & "</font>"
		Response.Write "</font>"
   end if
%><hr align="left" color="#000000" width="100%"><%
if( not flMonitoringEnabled )Then
	WriteText "Monitoring in not enabled"
elseif( flSrvRemoved )Then 
	WriteText "ASP Server has been removed or unexpected error has occurred."
elseif( flSesTerm )then 
	WriteText "monitor window is invalid since the current user " 
	Response.Write "<br>"
	WriteText "has been overwritten by another administrator"
	Response.Write "(" & Application("UserID") & ")"
else
if( not Session("MultiThreadEngine") )Then
	WriteDefFont
	Response.Write TranslateText( "Monitoring is not available when ASP Server is in Multi-Process mode." )
    Response.Write "</font>"
elseif not flRunning then 
	WriteDefFont
	Response.Write TranslateText( "ASP Server is stopped. To monitor the server you must " )
	WriteA "start", "server.action.asp?action=2&server=" & strServerURL, "HotLink"
	Response.Write TranslateText( " it." )
    Response.Write "</font>"
else %>
<table class="ListTable" border="0" width="100%" cellspacing="0" cellpadding="3">
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Total requests" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.Requests %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Requests per second" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.RequestsPerSecond %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Total errors received" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.Errors %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Current number of sessions" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.Sessions %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Script engines in memory" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.CachedScripts %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<%
' delete Active virtual hosts if we run on Web Server that is not Apache
'	if( 0=( (c_wsNetscape or c_wsZeus) AND GetWebServerID(strServer) ) )then 
	if (c_wsApache AND GetWebServerID(strWebVersion)) then %>
	
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Active virtual hosts" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText CStr(oServer.VirtualHosts) %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<% end if %>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Total memory in use" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.Memory & "KB" %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
<tr class="TableBody" bgcolor="#c0c0c0">
  <td width="50%" align="right"><% WriteText "Uptime" %></td>
  <td width="2%" align="left">&nbsp;</td>
  <td width="43%" align="left"><b><% WriteText oServer.UpTime %></b>&nbsp;</td>
  <td width="10%" align="left">&nbsp;</td>
</tr>
</table>
  <table border="0" width="98%" height="24">
    <% if not Request.QueryString("c")="1" then %>
    <tr>
      <td width="102%" colspan="4" height="15">
      <p align="left"><%
		WriteDefFont
		Response.Write  TranslateText( "page refreshes every " & strRefInterval & " seconds. click " )
		WriteA "here", "activemon.asp?c=1&server=" & strServerURL & "&sname=" & strServerNameURL, "HotLink"
		Response.Write TranslateText(" to change")
		%>
      </p>
      </td>
    </tr>
    <% else %>
  <form method="POST" id="form1" name="form1" action="save.refresh.asp">
    <tr>
      <td width="40%" height="1">
      <input type="hidden" name="server" value="<%= strServer %>">
      <input type="hidden" name="sname" value="<%= strServerName %>">
      <input type="hidden" name="sname" value="<%= strServerName %>">
      <% WriteText "Refresh this page every" %>
      </td>
      <td width="15%" height="1">
        <input type="text" name="RefrInterval" size="5" value="<%= strRefInterval%>">
      </td>
      <td width="17%" height="1"><% WriteText "seconds." %>
      </td>
      <td width="30%" height="1">
      <input type="submit" value="OK" name="btnRefresh" HEIGHT="20px" WIDTH="45px" style="HEIGHT: 20px; WIDTH: 45px">
      </td>
    </tr>
  </form>
   <% end if %>
  </table>
      </td>
    </tr>
  </table>
<% end if %>
<% end if %>
</div>

</body>
</html>
