<%
'constants for product update
const PU_TYPE_NO = 0
const PU_TYPE_NEW = 1
const PU_TYPE_DEMAND = 2
const PU_TYPE_PERIODIC = 3

const PU_PERIOD = 90 'check for product update every 90 DAYS

const PU_WEB_PRIVACY ="http://www.chilisoft.com/about/privacy.htm"
const PU_WEB_ACTION = "http://www.chilisoft.com/updates/updates.asp"

function PU_TEXT(puType)
	select case puType
	case PU_TYPE_NEW
		PU_TEXT = "Do you wish to check the Sun Chili!Soft site for security patches, bug fixes, or product updates? The following information about your Chili!Soft ASP installation will be transmitted with your request and used to determine the best update for your configuration.  NOTE: This information DOES NOT contain any personal or company identifying information. "
	case PU_TYPE_DEMAND
		PU_TEXT = "The Sun Chili!Soft site will be checked for security patches, bug fixes, or product updates. The following information about your Chili!Soft ASP installation will be transmitted with your request and used to determine the best update for your configuration.  NOTE: This information DOES NOT contain any personal or company identifying information. "
	case PU_TYPE_PERIODIC
		PU_TEXT = "The Sun Chili!Soft site has not been checked for security patches, bug fixes, or product updates in more than 90 days. If you wish to check for these now, the following information about your Chili!Soft ASP installation will be transmitted with your request and used to determine the best update for your configuration.  NOTE: This information DOES NOT contain any personal or company identifying information. "
	end select
end function

'check if product update is needed
function isUpdateNeeded(sServerLoc)
	dim oINIFile, strSection, strUpdateDate
	
	isUpdateNeeded = PU_TYPE_NO
	strSection = "Product Update"
	Set oINIFile = CreateObject("chili.inifile")
	oINIFile.Open (sServerLoc & "/casp.cnfg")

	strUpdateDate = getCnfgValue(oINIFile, strSection, "Date","", true)

	if strUpdateDate="" or not isdate(strUpdateDate) then
		isUpdateNeeded = PU_TYPE_NEW
		exit function
	else
		if datediff("d",CDate(strUpdateDate),date())>PU_PERIOD then
			isUpdateNeeded = PU_TYPE_PERIODIC
		end if
	end if
end function

'set update date
function setUpdateDate(sServerLoc)
	dim oINIFile, oSection, strSection, strUpdateDate
	
	strSection = "Product Update"
	Set oINIFile = CreateObject("chili.inifile")
	oINIFile.Open (sServerLoc & "/casp.cnfg")
	
	getSection oINIFile, strSection, oSection
	SetItem oSection, "Date", date(), true
end function

function getCaption(key)
	if key<>"" then
		if mid(key,1,1)<>"_" then
			getCaption = replace(key,"_"," ")
		end if
	end if
end function
function getCaption_o(key)
	select case key
	case "asp_version"
		getCaption = "ASP version"
	case "collection_date"
		getCaption = "Collection date"
	case "database_list"
		getCaption = "Databases"
	case "distribution"
		getCaption = "Distribution"
	case "distribution_version"
		getCaption = "Distribution version"
	case "form_verify"
		getCaption = "Form verify"
	case "form_version"
		getCaption = "Form version"
	case "gmt_offset"
		getCaption = "GMT offset"
	case "install_date"
		getCaption = "Install date"
	case "os"
		getCaption = "Operating system"
	case "os_version"
		getCaption = "Operating system version"
	case "processor"
		getCaption = "Processor"
	case "processor_count"
		getCaption = "Number of processor"
	case "unique_ID"
		getCaption = "Unique ID"
	case "webserver_type"
		getCaption = "Webserver"
	case "webserver_version"
		getCaption = "Webserver version"
	end select	
end function


%>