<SCRIPT LANGUAGE=VBScript RUNAT=Server>

Dim strTemp

Function IsMultiserversAllow
	IsMultiserversAllow = c_setMultiserversAllow ' Application("IsMultiserversAllow")	
End Function

Function IsMultiprocessAllow
	IsMultiprocessAllow = c_setMultiprocessAllow 'Application("IsMultiprocessAllow")
End Function

Function IsEngineMT( strServerLoc ) 
Dim oINIFile, oSecMachines, strValue

	if( not c_setMultiserversAllow )Then 
		Set oINIFile = CreateObject("chili.inifile")
		oINIFile.Open (strServerLoc & "/casp.cnfg")

		Set oSecMachines = oINIFile.Sections("machines")
				
		strValue = Trim( oSecMachines.Items("mtengine").Value )
		' determine the Engine mode from the casp.conf
		Session("MultiThreadEngine") = IsNumeric(strValue) and CInt(strValue)<>0 
	else
		Session("MultiThreadEngine") = true
	end if	

	IsEngineMT = Session("MultiThreadEngine")
	
end function 


Sub WriteTitle( strTitle, byval strSrvName, byval strSrv, strKeyword )
Dim flMSA, strSN, fl, strFile, altText
	flMSA = IsMultiserversAllow
	if( len(strSrv)>0 and flMSA )then
		strSN = " - <font color=""#777777"">" & Server.HTMLEncode( strSrvName ) & "</font>"
	else
		strSN = ""
	end if
	Response.Write "<TABLE BORDER=0 cellspacing=0 cellpadding=0 HEIGHT=""65"" WIDTH=""100%""><TR><TD ALIGN=LEFT VALIGN=MIDDLE WIDTH=""70%"">"
	Response.Write "<font face=""Arial, Helvetica, Verdana"" size=""4""><b>" & Server.HTMLEncode( strTitle ) & strSN & "</b></font>" 
	Response.Write "</TD><TD VALIGN=MIDDLE ALIGN=RIGHT WIDTH=""30%"">"

	altText = GetHelpAltText( strKeyword )

	if( ""<>altText )Then
	
		strFile = GetHelpFile( strKeyword )
	
		if( ""<>strFile ) Then
		
			strFile = Server.URLEncode(strFile)
			Response.Write "<form method=POST id=form1 name=form1>"
			Response.Write "<input type=button value=""" & TranslateText("Help") & """ name=""Help"" HEIGHT=""24px""" & _
				" WIDTH=""75px"" style=""HEIGHT: 24px; WIDTH: 75px;"" " & _ 
				"onclick=""javascript: SmallWin=window.open('" & c_DocRoot & "/anchor.asp?file=" & strFile & "&key=" & Server.URLEncode(strKeyword) & "', 'Documentation'); SmallWin.focus();"">" 
			Response.Write "</form>"
			
		end if
	end if
	Response.Write "</TD></TR></TABLE>"
	Response.Write "<hr color=""#000000"">"
        
	WriteFont "","1",""
	fl = len(strSrvName)>0 and flMSA and (true<>Session("HideNavigationBar"))
    if( fl )then
		if( Application("flRaq4") ) Then
			call WriteAStatus( "ASP Properties", "manage.server.asp", "Back to ASP Properties", "BlackLink" )
		else
			call WriteAStatus( "server management", "manage.server.asp", "Back to ASP servers list", "BlackLink" )
		end if
	end if
	if( 0<>Len(strSrv) )Then
		if( 0=InStr(1, Request.ServerVariables( "PATH_INFO" ), "server.props.asp", 1) )Then
			if( fl )then
				Response.Write ":"
			end if
			call WriteAStatus( iif( Application("flRaq4"), "ASP", "server" ) & " properties", "server.props.asp?server=" & Server.URLEncode(strSrv) , "Back to ASP server properties", "BlackLink" )
		end if
	end if
	Response.Write "<br><br>"
	Response.Write "</font>"
		
End Sub

' chech is the ASP server is running and returns Server object in second parameter
function IsServerRunning( strServer, oServer )
Dim  oInstDb
	Set oInstDb = Server.CreateObject("chili.installed_db")
	Set oServer = oInstDb.Servers(strServer)
	IsServerRunning = not (UCase(oServer.RunStatus)="STOPPED")
end function

' if flag in true returns true_res else false_res
function iif ( flag, true_res, false_res )
	if flag then
		iif = true_res
	else
		iif = false_res
	end if
end function



function QuoteString ( strSrt )
	QuoteString = """" & replace( strSrt, """", "\""") & """"
end function

function UnQuoteString ( strSrt )
Dim str1
	if len(strSrt)>1 then
		if Left(strSrt,1)="""" and Right(strSrt,1)="""" then
			str1 = Mid(strSrt,2,len(strSrt)-2)
		else 
			str1 = strSrt
		end if
		UnQuoteString = replace( str1, "\""", """")
	else
		UnQuoteString = str1
	end if
end function

' returns host name from the URL
' http://test.chilisoft.com:2355 ----> test.chilisoft.com
Function WebServerName( strURL )
Dim arSplit, index
	arSplit = split( strURL, ":", -1, 1)
	on error resume next
	index = 1
	if( "HTTP"<>UCase(arSplit(0)) )Then
		index = 0
	end if
	WebServerName = replace(arSplit(index), "//", "",1,2)
	if( Err.number<>0 ) then
			WebServerName = ""
	end if
	on error goto 0
End Function

' returns host port from the URL
' http://test.chilisoft.com:2355 ----> 2355
Function WebServerPort( strURL )
Dim arSplit, i, strPort
	arSplit = split( strURL, ":", -1, 1)
	strPort = ""
	on error resume next
	for i=1 to len(arSplit(2))
		if( 0<>InStr( "0123456789", Mid(arSplit(2),i,1) ) )Then
			strPort = strPort &  Mid(arSplit(2),i,1)
		end if
	next
	WebServerPort = strPort
	if( Err.number<>0 ) then
			WebServerPort = ""
	end if
	on error goto 0
End Function


' Sets the value of the key in the section
' oSection	object; Section object
' strKey	string; the key to be returned from the section
' strValue	string; the defauld value to be set to the value if the key doesn't exist and has to be created
' if the key in the section doesn't exist finction creats the key
' flagCreate	boolean; If it's true and the key doesn't exists it will atempt to creat the key setting the 
'						value to strDefaultValue
Function SetItem( oSection, strKey, strValue, flagCreate )
Dim flErr
	if( flagCreate )Then
		on error resume next
	end if
	oSection.Items(strKey).Value = strValue
	flErr = Err.number<>0
	on error goto 0
	if( flErr and flagCreate )then
		oSection.AddItem strKey, strValue
	end if
End Function

' Returns the ID of the platform the constants are definde in consts.asp
function GetPlatformID()
Dim strASP_OS
	strASP_OS=UCase(Request.ServerVariables("ASP_OS"))
	if(InStr(strASP_OS, "LINUX") > 0)Then
		GetPlatformID = c_osLinux
	elseif(InStr(strASP_OS, "AIX") > 0)Then
		GetPlatformID = c_osAIX
	elseif(InStr(strASP_OS, "SUNOS") > 0)Then
		GetPlatformID = c_osSolaris
	elseif(InStr(strASP_OS, "HP-UX") > 0)Then
		GetPlatformID = c_osHPUnix
	elseif(InStr(strASP_OS, "WINDOWS") > 0)Then
		GetPlatformID = c_osWindows
	else
		GetPlatformID = c_osUnknown
	end if
end function

' Returns the Name of the OS 
function GetPlatformName()
	select case GetPlatformID
		case c_osLinux		GetPlatformName="LINUX"
		case c_osAIX		GetPlatformName="AIX"
		case c_osSolaris	GetPlatformName="SUNOS"
		case c_osHPUnix		GetPlatformName="HP-UX"
		case c_osWindows	GetPlatformName="WINDOWS"
		case else			GetPlatformName="UNKNOWN"
	end select
end function

'7/20/01 JoeW: DB2 different on Unix/Linux, see odbc.add.asp
function isUnix(lPlatformID)
	isUnix = false
	if lPlatformID=c_osAIX or lPlatformID=c_osSolaris or lPlatformID=c_osHPUnix then
		isUnix = true
	end if
end function
function isLinux(lPlatformID)
	isLinux = false
	if lPlatformID=c_osLinux then
		isLinux = true
	end if
end function

'Modified: 09/04/01
'Reason: ServerLocation renamed, doesn't contain type of webserver anymore
'Joew: strWebServer -- oServer.WebVersion (WebServerName Version)
' Returns the ID of the Web Server
function GetWebServerID( strWebServer )
	dim pos, strServer
	pos = instr(1,strWebServer," ")
	if pos>0 then
		strServer = ucase(trim(mid(strWebServer,1,pos-1)))
	end if
	select case strServer
	case "APACHE"
		GetWebserverID = c_wsApache
	case "NETSCAPE"
		GetWebserverID = c_wsNetscape
	case "ZEUS"
		GetWebserverID = c_wsZeus
	case else
		GetWebserverID = c_wsUnknown
	end select
end function

' Writes a tab HTML for the tab control
Function WriteTab( strText, strURL, strStatusText, flSelected )
Dim strTabClass, strSelColor
	if( flSelected )Then
		strTabClass="SelectedTab"
		strSelColor = c_SelTabColor
	else
		strTabClass="Tab"
		strSelColor = c_TabColor
	end if
	Response.Write "<td bgColor=""" & strSelColor & """ class=""" & strTabClass & """><img height=""20"" src=""" & c_VirtualRoot & "/images/tableft.gif"" width=""6"" alt=""""></td>"
	Response.Write "<td bgColor=""" & strSelColor & """ class=""" & strTabClass & """ NOWRAP>"
	WriteAStatus strText, strURL, strStatusText, strTabClass
	Response.Write "</td>"
	Response.Write "<td bgColor=""" & strSelColor & """ class=""" & strTabClass & """><img height=""20"" src=""" & c_VirtualRoot & "/images/tabright.gif"" width=""6"" alt=""""></td>"
End Function

' Makes Anchor <A> element witht status text adding VHost
Function GetAStatus( strText, strURL, strStatusText, strClass)
	GetAStatus="<A class=""" & strClass & """ onmouseover=""javascript: window.status='" & TranslateText(strStatusText) & "'; return true;"" onmouseout=""javascript: window.status='';"" href=""" & c_VirtualRoot & "/" & strURL & """>" & _
			TranslateText( strText ) & "</A>"
End Function


' Writes Anchor <A> element witht status text
Function WriteAStatus( strText, strURL, strStatusText, strClass )
	Response.Write GetAStatus(strText, strURL, strStatusText, strClass)
End Function

' Writes Anchor <A> element witht status text
Function WriteAStatusFont( strText, strURL, strStatusText, strClass )
	WriteDefFont
	Response.Write GetAStatus(strText, strURL, strStatusText, strClass)
	Response.Write "</font>"
End Function

' Makes Anchor <A> element witht status text 
Function GetAStatusNoVH( strText, strURL, strStatusText, strClass)
	GetAStatusNoVH="<A class=""" & strClass & """ onmouseover=""javascript: window.status='" & strStatusText & "'; return true;"" onmouseout=""javascript: window.status='';"" href=""" & strURL & """>" & _
			TranslateText( strText ) & "</A>"
End Function

' Writes Anchor <A> element witht status text
Function WriteAStatusNoVH( strText, strURL, strStatusText, strClass)
	Response.Write GetAStatusNoVH(strText, strURL, strStatusText, strClass)
End Function

' Gets Anchor <A> element
Function GetA( strText, strURL, strClass)
	GetA="<A class=""" & strClass & """ href=""" & c_VirtualRoot & "/" & strURL & """>" & TranslateText( strText ) & "</A>"
End Function

' Gets Anchor <A> element with pure HTML in the body
Function GetAHTML( strText, strStatusText, strURL, strClass)
	GetAHTML="<A class=""" & strClass & """ onmouseover=""javascript: window.status='" & TranslateText(strStatusText) & "'; return true;"" onmouseout=""javascript: window.status='';"" href=""" & c_VirtualRoot & "/" & strURL & """>" & _
			 strText & "</A>"
End Function

' Writes Anchor <A> element
Function WriteA( strText, strURL, strClass)
	Response.Write GetA(strText, strURL, strClass)
End Function

' Gets Button element
Function GetButton( strType, strName, strValue, strResultElem, strResValue, strHeight, strWidth, strExtraStyle )
Dim strRVal
	if( IsEmpty(strHeight) or ""=strHeight )Then
		strHeight = "24px"
	end if
	if( IsEmpty(strWidth) or ""=strWidth )Then
		strWidth = "75px"
	end if
	if( IsEmpty(strResultElem) or ""=strResultElem )Then
		GetButton="<input type=""" & strType & """ value=""" & TranslateText(strValue) & """ name=""" & strName & """ HEIGHT=""" & strHeight & _
			""" WIDTH=""" & strWidth & """ style=""HEIGHT: " & strHeight & "; WIDTH: " & strWidth & "; " & strExtraStyle & """>"
	else
		if( IsEmpty(strResValue) or ""=strResValue )Then
			strRVal = strValue
		else
			strRVal = strResValue
		end if
		GetButton="<input type=""" & strType & """ value=""" & TranslateText(strValue) & """ name=""" & strName & """ HEIGHT=""" & strHeight & _
			""" WIDTH=""" & strWidth & """ style=""HEIGHT: " & strHeight & "; WIDTH: " & strWidth & "; " & strExtraStyle & """ " & _ 
			"onclick=""javascript: this.form." & strResultElem & ".value='" & strRVal & "'; "">" 
	end if
End Function

' Write Button element
Function WriteButton( strType, strName, strValue, strResultElem, strResValue, strHeight, strWidth, strExtraStyle )
	Response.Write GetButton( strType, strName, strValue, strResultElem, strResValue, strHeight, strWidth, strExtraStyle )
End Function

' Gets Hidden element
Function GetHidden( strName, strValue )
	GetHidden="<input type=""hidden"" value=""" & TranslateText(strValue) & """ name=""" & strName & """>"
End Function

' Write Hidden element
Function WriteHidden( strName, strValue)
	Response.Write GetHidden( strName, strValue )
End Function


' Gets Default Font element
Function GetDefFont()
	GetDefFont="<font face=""" & c_DefFont & _
			""" size=""" & c_DefFontSize & _
			""" color=""" & c_DefFontColor & """>"
End Function

' Write Default Font element
Function WriteDefFont()
	Response.Write GetDefFont
End Function

' Gets Font element
Function GetFont( strFont, Size, Color)
	GetFont="<font face=""" & iif(IsEmpty(strFont) or ""=strFont, c_DefFont, strFont ) & _
			""" size=""" & iif((IsEmpty(Size) or ""=Size), c_DefFontSize, Size ) & _
			""" color=""" & iif((IsEmpty(Color) or ""=Color), c_DefFontColor, Color ) & """>"
End Function

' Write Font element
Function WriteFont(  strFont, Size, Color )
	Response.Write GetFont( strFont, Size, Color )
End Function

Function WriteTextFont(  strText, strFont, Size, Color )
	Response.Write GetFont( strFont, Size, Color ) & Server.HTMLEncode( TranslateText(strText) ) & "</font>"
'	Response.Write Server.HTMLEncode( TranslateText(strText) )
End Function

Function WriteText(  strText  )
	Response.Write GetDefFont & Server.HTMLEncode( TranslateText(strText) ) & "</font>"
'	Response.Write Server.HTMLEncode( TranslateText(strText) )
End Function

Function WriteTextNoTrans(  strText  )
	Response.Write GetDefFont & Server.HTMLEncode( strText ) & "</font>"
End Function

Sub SetNavigLinks( strHTML, ByVal iLevel, strSessionVar )
Dim arrLevels, i
	if( ""=strSessionVar )Then
		arrLevels = Session("arrUserNavigationPath")
	else
		arrLevels = Session(strSessionVar)
	end if
	if( IsEmpty(arrLevels) )Then
		Dim tmpArr(5)
		arrLevels = tmpArr
	end if
	i=LBound(arrLevels)+iLevel-1
	if( i>LBound(arrLevels)+c_MaxLevelsNavigation-1 )Then
		i = LBound(arrLevels)+c_MaxLevelsNavigation-1
	end if
	arrLevels(i)=strHTML
	arrLevels(i+1)=Empty
	if( ""=strSessionVar )Then
		Session("arrUserNavigationPath") = arrLevels 
	else
		Session(strSessionVar) = arrLevels 
	end if
end sub 

Sub WriteNavigLinks (strSessionVar)
Dim arrLevels, i
	if( ""=strSessionVar )Then
		arrLevels = Session("arrUserNavigationPath")
	else
		arrLevels = Session(strSessionVar)
	end if
	for i=LBound(arrLevels) to UBound(arrLevels)
		if( (Not IsEmpty(arrLevels(i))) AND ""<>arrLevels(i) )Then
			if( i>LBound(arrLevels) )Then
				Response.Write c_strNavigDelimit
			end if 
			Response.Write arrLevels(i)
		else
			exit for
		end if 
	next
	Response.Write "<BR><BR>"
end sub 

' base function for writing a text on the UI


function ErrMsg( msg )
	
	Session("ErrDescription") = CStr(msg)
	Response.Redirect c_VirtualRoot & "/error.asp?error=-1"
	
end function


' used for localization purpose
Function TranslateText( strText )
	TranslateText = strText
end function

Function GetHelp( strKeyword )

	Dim arrHelp, altText, i, str
	
	
	altText = GetHelpAltText( strKeyword )
	
	if( ""<>altText )Then
	
		Dim strFile, altTextStatus
	
		strFile = GetHelpFile( strKeyword )
	
		altTextStatus = replace( altText, "'", "\0x27")
		altTextStatus = replace( altTextStatus, vbCr, " ")
		altTextStatus = replace( altTextStatus, vbLf, " ")
		altTextStatus = replace( altTextStatus, "  ", " ")
		altTextStatus = replace( altTextStatus, """", "\0x22")
		
		GetHelp = "<A onmouseover=""javascript: window.status='" & altTextStatus & "'; return true;"" onmouseout=""javascript: window.status='';""" & _
				  "href=""javascript: SmallWin=window.open('" & c_DocRoot & "/anchor.asp?file=" & Server.URLEncode(strFile) & "&key=" & Server.URLEncode(strKeyword) & "', 'Documentation'); SmallWin.focus();"" TABINDEX=1000>" & _
   				  "<IMG BORDER=0 SRC=""" & c_VirtualRoot & "/images/q.gif"" ALT=""" & Server.HTMLEncode(altText) & """></A>"	
	else
		GetHelp = ""
	end if
	
End Function 

Function GetHelpAltText ( strKey )
	GetHelpAltText = Application( strKey & "_a" )
End Function

Function GetHelpFile ( strKey )
	GetHelpFile = Application( strKey & "_f" )
End Function


Function WriteHelp( strKeyword )
	Response.Write "&nbsp;"
	Response.Write GetHelp( strKeyword )
end Function  


Function WriteTextHelp( strText, strKeyword )
	WriteText(strText)
	WriteHelp( strKeyword )
end Function  

Function RepaceToken(strSrt, strToken, strValue)
	if( not IsNull(strSrt) )Then
		RepaceToken = Replace(strSrt, "<<" & Trim(strToken) & ">>", strValue)
	end if
End Function

'Returns true is the value is not zero, "no" or "false"
'parameter is case insesitive
function IsFlagValueON( vValue )
Dim strVal
	strVal = UCase( Trim( CStr( vValue ) ) )
	if( "0"=strVal or "no"=strVal or "false"=strVal ) Then 
		IsFlagValueON = false
	else
		IsFlagValueON = true
	end if
end function


' Gets the value of the Item in the section
' if the key in the section doesn't exist finction creats the key
' oSection	object; Section object
' strKey	string; the key to be returned from the section
' strDefaultValue	string; the defauld value to be set to the value if the key doesn't exist and has to be created
' flagCreate	boolean; If it's true and the key doesn't exists it will atempt to creat the key setting the 
'						value to strDefaultValue
Function GetItem( oSection, strKey, strDefaultValue, flagCreate )
Dim flErr
	'if( flagCreate)Then
		on error resume next
	'end if
	GetItem = oSection.Items(strKey).Value
	flErr = Err.number<>0
	on error goto 0
	if( flErr and flagCreate )then
		oSection.AddItem strKey, strDefaultValue
		GetItem = strDefaultValue
	end if
End Function


Function GetINIValue( strFile, strSection, strKey, strDefaultValue, flagCreate )
Dim oINIFile, oSection, strValue

	Set oINIFile = Server.CreateObject("chili.inifile")
	oINIFile.Open (strFile)

	Set oSection = oINIFile.Sections(strSection)
	
	GetINIValue = GetItem( oSection, strKey, strDefaultValue, flagCreate )
			
end function

'joew: oINIFile.Sections in the above function returns error if the section doesn't exist
'return item from casp.cnfg
'oINIFile -- ini component
'strSection -- section name
'strKey -- key of an item in the section
function getCnfgValue(oINIFile, strSection, strKey, strDefaultValue, flagCreate)
	dim oSection
	getSection oINIFile, strSection, oSection
	getCnfgValue = trim(GetItem( oSection, strKey, strDefaultValue, flagCreate ))
end function


'get Section object by section name
'add the section if doesn't exist
function getSection(oINIFile, strSection, oSection)
	on error resume next
'	if isobject(oSection) then exit function
	Set oSection = oINIFile.Sections(strSection)
	if err.number>0 or not isobject(oSection) then
		oINIFile.addSection strSection
		Set oSection = oINIFile.Sections(strSection)
	end if
	on error goto 0
end function

'7/23/01 JoeW:
'convert a integer to a string of length iCap, preceding "0"s are added when neccessary
function itofullstr(iNum, iCap)
	dim sTemp, sTemp1, iLen
	sTemp = cstr(iNum)
	iLen = len(sTemp)
	if iCap>iLen then
		sTemp = string(iCap-iLen, "0") & sTemp
	end if
	itofullstr = sTemp
end function

'joew: the CSAdmin component returns error when an item doesn't exist in a collection
function getItemInCol(oCol, kItem, vItem, vDefault)
	on error resume next
	vItem = oCol.Items(kItem)
	if err.number<>0 then
		vItem = vDefault
	end if
	on error goto 0
end function

'joew: loop through col to search for item 'kItem', if exists, return its value, otherwise returns Default value
function getItemInColex(oCol, kItem, vItem, vDefault)
	dim oneItem
	
	vItem = vDefault
	for each oneItem in oCol
		if oneItem.key = kItem then
			vItem = oneItem.value
		end if
	next
	
end function



'-------------------------------------------------------------------------------
'joew: matching array and returns value if found
'Purpose:   Get value from a look-up table by selected value
'Inputs:
'   lkupArray   - array, returned array
'   refItem     - the item to be matched
'   refItemValue    - the value of the item to be matched
'   retItem     - the item to be returned
'	defValue	- return this value if not find
'-------------------------------------------------------------------------------
Function GetLkupValue(LkupArray, intDim, refItem, refItemValue, retItem, defValue)
    Dim intRow
    GetLkupValue = defValue
    If (Not IsNull(LkupArray)) Then
        ' Loop thru the rows in the array
        if intDim=2 then
			For intRow = 0 To UBound(LkupArray, 2)
			    If ConvertNull(LkupArray(refItem, intRow)) = Trim(refItemValue) Then
			        GetLkupValue = LkupArray(retItem, intRow)
			        Exit For
			    End If
			Next
		elseif intDim=1 then
			For intRow = 0 To UBound(LkupArray)
			    If ConvertNull(LkupArray(intRow)) = Trim(refItemValue) Then
			        GetLkupValue = LkupArray(intRow)
			        Exit For
			    End If
			Next
		end if		
    End If
End Function
'-------------------------------------------------------------------------------
'Purpose:	Get the index from a look-up table by selected value
'Inputs:	
'	lkupArray	- array, returned array
'	refItem		- the item to be matched
'	refItemValue	- the value of the item to be matched
'-------------------------------------------------------------------------------
Function GetLkupIndex(LkupArray, refItem, refItemValue)
	Dim intRow
	GetLkupIndex=0
	If (Not IsNull(LkupArray)) Then
		' Loop thru the rows in the array
		For intRow = 0 to UBound(LkupArray, 2)
			If ConvertNull(LkupArray(refItem, intRow)) = Trim(refItemValue) Then
				GetLkupIndex=intRow
				Exit For
			End If
		Next
	End If
End Function
Function ConvertNull(varTemp)
	If IsNull(varTemp) Then
		ConvertNull = ""
	Else
		ConvertNull = Trim(varTemp)
	End If
End Function

'-----------------------------file operation----------------------------
' Returns the apropriate path separator depanding on the OS
function GetPathSlash()
Dim strAspOs
	strAspOs = Request.ServerVariables("ASP_OS")
	If 0<>InStr(1,strAspOs,"WINDOWS",1) Then
		GetPathSlash = "\"
	Else
		GetPathSlash = "/"
	End If
end function

' returns the directory from file path
Function GetPath( strPath )
Dim MyArr, strSlash, strAspOs
	strSlash = GetPathSlash()
    MyArr = Split(strPath, strSlash)
    MyArr(UBound(MyArr)) = ""
    GetPath = Join(MyArr, strSlash)
End Function

' returns the filename from path
Function GetFile( strPath )
Dim MyArr, strSlash, strAspOs
	strSlash = GetPathSlash()
    MyArr = Split(strPath, strSlash)
    GetFile = MyArr(UBound(MyArr))
End Function


' creats new text file on the disk 
' strFileName - the name of the file includding the path and it is set to the full name of the created file 
'				if the default folder has been applied		
' strDefaultDir - default folder if path is not specified in strFileName
' flOverWrite - if TRUE and the file is exists it it'll be overwrited
' return: Integer - 0 is file has been created successfuly;
'					1 if it failed to create the file 
'					2 if a file is already exists
Function CreateTXTFile( strFileName, strDefaultDir, flOverWrite )
Dim strLogFile, strPath, oFS, txtFile, flerr

	strLogFile = Trim(strFileName)
	if len(strLogFile)>0 then
		' if no path has been specified get the default 
		strPath = GetPath(strLogFile)
		if strPath="" then
			strLogFile = strDefaultDir & GetPathSlash() & strLogFile
		end if 

		strFileName = strLogFile

		Set oFS = Server.CreateObject("Scripting.FileSystemObject")

		if (oFS.FileExists(strLogFile) and not flOverWrite) then
			' file exists
			CreateTXTFile = 2
			exit function
		end if 
				
		on error resume next
		Set txtFile = oFS.CreateTextFile (strFileName, flOverWrite)
		txtFile.WriteLine ("Created at " & Date & " " & Time)
		flerr = Err.number
		txtFile.Close
		on error goto 0
		CreateTXTFile = iif((flerr = 0), 0, 1)
	else 
		CreateTXTFile = 1
	end if 
end function

'Joew: strFile is filename with fullpath
function DeleteFile(strFile)
	dim Folder
	DeleteFile = true
	Set FSO = Server.CreateObject("Scripting.FileSystemObject")
	If Not FSO.FileExists(strFile) Then
		DeleteFile = false
	else
		FSO.DeleteFile strFile, true			
	End If
	set FSO = nothing
	if err.number>0 then DeleteFile = false
end function
'-----------------------------end of file operation----------------------------
</SCRIPT>
