<% 
const c_DriversDSN = "DSN=DRIVERS;"
const c_DSNTestFile = "dsntest"
const c_NoPassword = "P-A-S-S-W-O-R-D"

' Constants for ODBC tab
const c_tabDSN = 1
const c_tabDrv = 2
const c_tabConnPool = 3
const c_tabDBEnvVar = 4
const c_tabDB2Pf = 5
const c_tabDSNTemplates = 6

' Constants for DB Engines
const c_PostgreSQL = 1
const c_MySQL = 2
const c_SequeLink = 3
const c_dBASE = 4
const c_Oracle = 5
const c_MSSQL = 6
const c_Sybase = 7
const c_Informix = 8
const c_DB2 = 9
const c_OpenIngres = 10
const c_InterBase = 11

const c_idxControl = 0
const c_idxValue = 1
const c_idxDefVal = 2
const c_idxFldSize = 3
const c_idxShowUI = 4
const c_idxFunc = 5

const c_TemplateID = "_template"

' version number of the current Merant drivers 
' 1			'Version 1.5, 1.6
' 2			'Version 1.7
const c_drvMirantCurrent = 2

' Constants for DB2 profile files
Const strPfFileName = "/db2setup.sh"
Const cstrSourceCmd = "/INSTALL/db2loadprofile.sh"
Const cstrDB2DrvVar = "target="

' FileSystem file open constants
Const ForReading = 1, ForWriting = 2, ForAppending = 8

function ODBCTab( ActiveTab )
	WriteTab "Global Data Source Names", "odbc/odbc.dsn.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "Add/Edit/Remove Data Source Names", c_tabDSN=ActiveTab
	'WriteTab "DSN Templates", "odbc/odbc.dsn.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "Add/Edit/Remove Data Source Names", c_tabDSNTemplates=ActiveTab
	WriteTab "Drivers", "odbc/odbc.drv.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "List supported ODBC Drivers", c_tabDrv=ActiveTab
	WriteTab "ADO Settings", "odbc/odbc.pool.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "ADO Settings", c_tabConnPool=ActiveTab
	WriteTab "Environment", "odbc/odbc.env.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "Environment", c_tabDBEnvVar=ActiveTab
	'if( c_osSolaris<>Application("PlatformID") and c_osHPUnix<>Application("PlatformID") )Then
	'	WriteTab "DB2 Profiles", "odbc/odbc.db2pf.asp?srv=" & strServerURL & "&sname=" & strSNameURL, "DB2 Profiles", c_tabDB2Pf=ActiveTab
	'end if
end function

Dim g_ODBCActiveTab

Function SetODBCINIFile( strINIFile, oSectionDSNs )
Dim oINIFile
	Set oINIFile = Server.CreateObject("chili.inifile")
	on error resume next
	oINIFile.Open strINIFile
	Set oSectionDSNs = oINIFile.Sections("ODBC Data Sources")
	if( 0<>Err.number )Then
		ErrMsg( Err.description )
	end if
	on error goto 0
	Set SetODBCINIFile = oINIFile
end Function

function SupportedEnginesSQL ( strOSKey )

	SupportedEnginesSQL = "SELECT ENGOS.ID, EngOS.ENGID, EngOS.OSID, TRIM(e.Name) AS NAME, IIF(TRIM(e.Version)='_', '', TRIM(e.Version)) AS VERSION " & _
		"FROM ENGOS, OS, ENGINES e, DRIVERS d " & _
		"WHERE (OS.KEY='" & UCase(strOSKey) & "' AND OS.ID=EngOS.OSID AND e.ID=EngOS.ENGID) " & _
		    " and (d.ENGOSID=EngOS.ID AND " & _
			"(d.CASPVER=0 OR d.CASPVER=" & c_drvMirantCurrent & "))" & _
		"ORDER BY e.NAME"
	
end function

'updated: 7/19/01 by JoeW
'Database design change.  DRVENGOS dropped
function SupportedDriversSQL ( iEngOSID )
	SupportedDriversSQL = "SELECT DRIVERS.ID, TRIM(DRIVERS.FileName) AS FileName, IIF(TRIM(DRIVERS.Version)='_', '', TRIM(DRIVERS.Version)) AS VERSION, TRIM(DRIVERS.Notes) AS Notes, TRIM(DRIVERS.ACTION) AS ACTION " & _
		"FROM DRIVERS " & _
		"WHERE (DRIVERS.ENGOSID=" & iEngOSID & " AND " & _
			"(DRIVERS.CASPVER=0 OR DRIVERS.CASPVER=" & c_drvMirantCurrent & ")) " & _
		"ORDER BY DRIVERS.ENGOSID"
end function

'updated: 7/19/01 by JoeW
'Database design change.  DRVENGOS dropped
function AllDriversPerOSSQL ( strOSKey )

	AllDriversPerOSSQL = "SELECT e.ID AS ENGID, TRIM(e.Name) AS ENGNAME, IIF(TRIM(e.Version)='_', '', TRIM(e.Version)) AS ENGVER, " & _
			"TRIM(d.FileName) AS DRVFILE, IIF(TRIM(d.Version)='_', '', TRIM(d.Version)) AS DRVVER, TRIM(d.Notes) AS DRVNOTES, " & _
			"TRIM(dl.DRVLOCAT) AS DRVLOCAT " & _
		"FROM ENGOS eo, OS o, ENGINES e, DRIVERS d, DRVLOCAT dl " & _
		"WHERE (o.KEY='" & UCase(strOSKey) & "' AND eo.OSID=O.ID AND " & _
			"eo.ENGID=e.ID AND d.ENGOSID=eo.ID AND dl.ID=d.DRVLOCID AND " & _
			"(d.CASPVER=0 OR d.CASPVER=" & c_drvMirantCurrent & ")) " & _
		"ORDER BY eo.ENGID"
	
end function

'updated: 7/19/01 by JoeW
'Database design change.  DRVENGOS dropped; DRVATT added
function AttributesSQL ( iDRVID )

	AttributesSQL = "SELECT da.ACSUPP, a.ID, TRIM(a.FRNAME) AS FRNAME, da.SHOWUI, TRIM(a.Name) AS Name, TRIM(da.Default) AS Default, " & _
			"TRIM(i.KEY) AS Control, e.ID as ENGID, " & _
			"TRIM(d.FILENAME) AS FILENAME, TRIM(e.NAME) AS ENGNAME, TRIM(dl.DRVLOCAT) AS DRVLOCAT, " & _
			"TRIM(da.REGEXPR) AS RegExpr, TRIM(da.VALIDMSG) AS ValidMsg, da.FIELDLEN, da.FUNC " & _  
		"FROM ATTS a, INPUTS i, DRVATT da, DRIVERS d, DRVLOCAT dl, ENGOS es, ENGINES e " & _
		"WHERE (d.ID=" & iDRVID & " AND d.ID=da.DRVID AND da.ATTID=a.ID AND " & _
			"da.INPUTID=i.ID AND d.DRVLOCID=dl.ID AND d.ENGOSID=es.ID AND es.ENGID=e.ID AND da.ACSUPP<>0) " & _
		"ORDER BY da.INDEX ASC"
	
end function

'updated: 7/19/01 by JoeW
function DriverAttribsSQL ( strDriver, strOSKey )
	DriverAttribsSQL = "SELECT D.ID, TRIM(D.FILENAME) AS FILENAME, IIF(TRIM(D.Version)='_', '', TRIM(D.Version)) AS DRVVER, E.ID as ENGID, " & _
					"TRIM(A.NAME) AS ATTNAME, TRIM(I.KEY) AS CONTROL, TRIM(da.REGEXPR) AS REGEXPR, " & _
					"TRIM(da.VALIDMSG) AS VALIDMSG, TRIM(da.DEFAULT) AS DEFAULT, da.SHOWUI, TRIM(E.NAME) AS ENGNAME, " & _
					"IIF(TRIM(E.Version)='_', '', TRIM(E.Version)) AS ENGVER, da.FIELDLEN AS FIELDLEN, da.FUNC " & _
					"FROM DRIVERS D, INPUTS I, DRVATT da, ATTS A, ENGOS es, ENGINES E, OS " & _
					"WHERE OS.KEY='" & UCase(strOSKey) & "' and D.FILENAME='" & strDriver & "' AND D.ID=da.DRVID and da.INPUTID=I.ID and da.ATTID=A.ID and D.ENGOSID=es.ID AND es.ENGID=E.ID and es.OSID=OS.ID " & _
					"ORDER BY D.ID, E.ID, da.INDEX"
end function

function DriverEngineSQL ( )
	DriverEngineSQL = "SELECT D.ID, E.ID AS ENGID, TRIM(D.FILENAME) AS FILENAME, IIF(TRIM(d.Version)='_', '', TRIM(d.Version)) AS DRVVER, " & _
					"TRIM(E.NAME) AS ENGNAME, " & _
					"IIF(TRIM(E.Version)='_', '', TRIM(E.Version)) AS ENGVER " & _
					"FROM DRIVERS D, ENGOS es, ENGINES E " & _
					"WHERE D.ENGOSID=es.ID AND es.ENGID=E.ID " & _
					"ORDER BY D.ID"
end function

' Creates Array and Dictionary object from DNS section from ODBC.INI and Recordset from the DNS system database
'
Function MergeDSNAtts( rsDrvProps, oSection, oDict, PasswordIndex)
	Dim arDict(), nIndex, oKeyPear, strTemp2, iSize
	dim iShowUI, vDefVal, iFunc
	PasswordIndex = -1
									
	Set oDict = Server.CreateObject("Scripting.Dictionary")
									
	oDict.CompareMode = 1
	
	if( not IsEmpty(oSection) )Then
		if( oSection.Items.Count<3 )Then
			ReDim arDict(2)
		else
			ReDim arDict(oSection.Items.Count-1)
		end if
	else
		ReDim arDict(2)
	end if
	
	arDict(0)="Description"
	oDict.Add arDict(0), Array( "TEXT", "", "", c_DefTextFieldLen, 0, 0 )
						'      control, value, default value, size, showui, func
						'const c_idxControl = 0,const c_idxValue = 1, c_idxDefVal,const c_idxFldSize = 2,const c_idxShowUI = 3

	arDict(1)="Driver"
	oDict.Add arDict(1), Array( "TEXT", "", "", c_DefTextFieldLen, 0, 0 )
	
	
	nIndex=2
	rsDrvProps.MoveFirst
	do while not rsDrvProps.EOF
		arDict(nIndex) = rsDrvProps("ATTNAME").Value
		oDict.Add arDict(nIndex), Array( rsDrvProps("CONTROL").Value, _
			rsDrvProps("DEFAULT").Value, rsDrvProps("DEFAULT").Value, _
			iif( IsNull(rsDrvProps("FIELDLEN").Value), c_DefTextFieldLen, rsDrvProps("FIELDLEN").Value),  rsDrvProps("SHOWUI").Value, rsDrvProps("FUNC").value)
		
		if( "PASSWORD"=rsDrvProps("CONTROL").Value )Then PasswordIndex = nIndex
		
		rsDrvProps.MoveNext
		nIndex = nIndex + 1
		if( nIndex>UBound(arDict) )Then
			ReDim Preserve arDict( UBound(arDict)+UBound(arDict)\2 )
		end if
	
	loop
	
	if( not IsEmpty(oSection) )Then	
		for each oKeyPear in oSection.Items
			if( not oDict.Exists(oKeyPear.Key) )Then
				arDict(nIndex) = oKeyPear.Key
				strTemp2 = "TEXT"
				iSize = c_DefTextFieldLen
				nIndex = nIndex + 1
				if( nIndex>UBound(arDict) )Then
					ReDim Preserve arDict( UBound(arDict)+UBound(arDict)\2 )
				end if
				iShowUI = 0
				vDefVal = ""
				iFunc = 0
			else
				strTemp2 = oDict.Item(oKeyPear.Key)(c_idxControl)
				iSize = oDict.Item(oKeyPear.Key)(c_idxFldSize)
				iShowUI = oDict.Item(oKeyPear.Key)(c_idxShowUI)
				vDefVal = oDict.Item(oKeyPear.Key)(c_idxDefVal)			
				iFunc = oDict.Item(oKeyPear.Key)(c_idxFunc)
			end if
			oDict.Item(oKeyPear.Key)=Array( strTemp2, oKeyPear.Value, vDefVal, iSize, iShowUI, iFunc )
		next
	end if
	
	nIndex=nIndex-1
	if( nIndex<UBound(arDict) )Then
		ReDim Preserve arDict( nIndex )
	end if

	MergeDSNAtts = arDict
									
end function

'7/20/01 JoeW:
'Driver action handler
'get action paramemters:
function getActionParam(strDrvAction)
	dim strDSN
	strDSN = Request.Form("dsn")
	getActionParam = replace(strDrvAction,"<DSN>",strDSN,1,10,1)	
	
end function

'check if the DSN in concern is for DB2 on UNIX
function isDB2PkgExist(oSectionSource)
	dim sTemp
	isDB2PkgExist = false
	on error resume next
	sTemp = oSectionSource.Items("Package")
	if Err.number=0 then
		if instr(1,sTemp, "DEF")=1 then
			isDB2PkgExist = true
		end if
	end if
	on error goto 0
end function

'7/25/01 Joew:
'remove a DSN section from ini file
function removeDSN(strFile, strDSN)
	dim oINIFile, oSectionDSNs
	Set oINIFile = CreateObject("chili.inifile")
	oINIFile.Open (strFile)
	on error resume next
	Set oSectionDSNs = oINIFile.Sections("ODBC Data Sources")
	if( 0<>Err.number )Then
		ErrMsg( Err.description )
	end if
	on error goto 0
	oSectionDSNs.DeleteItem( strDSN )
	oINIFile.DeleteSection(	strDSN )
	
end function
'7/23/01 Joew:
'Attributes action handler
'arAtts -- array holding attributes name-values where arAtts(0,i) are names, arAtts(1,i) are values and arAtts(2,i) are action flags
function ATTRAction(byref arAtts, i, iCount,oINIFile, strDriver)
	dim bAction, strAction, pos, pos1, strFunction, strParams
	bAction = arAtts(2,i)
	ATTRAction = true
	if bAction then	
		strAction = arAtts(1,i)
		if strAction<>"" then
			pos = instr(1,strAction,"(")
			if pos>0 then
				strFunction = mid(strAction,1,pos-1)
				pos1 = instr(pos,strAction,")")
				if pos1>pos+1 then
					strParams = trim(mid(strAction,pos+1,pos1-pos-1))
				end if
				select case strFunction 
				case "getPackage" 'DB2 package
					if not getPackage(arAtts, i, iCount,oINIFile, strDriver) then
						ErrMsg( "Merant driver allows a maximum 100 packages (00--99).  The Admin Console can't add new packages.  Please remove unused DSNs and then repeat the previous steps to add new DSN."  )
						ATTRAction = false
					end if
				case "Combine"
					CombineAtts strParams, arAtts, i, iCount
				end select
			end if
		end if
	end if
end function

function CombineAtts(strParams, arAtts, iAtt, iCount)
	dim s, pos, sOneParam, sValue
	if strParams<>"" then
		s = strParams
		pos =1
		do
			sOneParam = getOneParam(s, pos)
			if pos=0 then 'no param found
				exit do
			end if
			sValue = getAttValue(arAtts, iCount, sOneParam)
			s = replace(s,"[" & sOneParam & "]",sValue)
			pos = pos + len(sValue) - (len(sOneParam)+2)
		loop
		arAtts(1,iAtt) = s
	end if
end function
function getAttValue(arAtts, iCount, sName)
	dim i
	for i=0 to iCount-1
		if arAtts(0,i)=sName then
			getAttValue = arAtts(1,i)
		end if
	next
end function
function getOneParam(s, curPos)
	dim pos, pos1
	getOneParam = ""
	if s<>"" then
		pos = instr(curPos, s, "[")
		if pos>0 then
			pos1 = instr(pos, s, "]")
			if pos1>0 then
				getOneParam = trim(mid(s,pos+1,pos1-pos-1))
			end if
		end if
		curPos = pos1
	end if
end function
'get DB2 package in format: "DEF" + xx (two digits)
function getPackage(arAtts, iAtts, iAttCount,oINIFile, strDriver)
	dim oSection, dsnItem
	dim sDSNSec, oDSNSec, strDriver1
	dim iPkgmax, iPkg, iPkg1, sPkg, sPkgTemp, iNumDigit, bExist
	dim arPkgs, iCount, iLen
	dim i
	sPkg = "DEF"
	iNumDigit = 2
	iPkgmax = 0
	iPkg1 = 0
	iCount = 0
	iLen = 9
	redim arPkgs(iLen)
	bExist = false
	on error resume next
	getPackage = false
	Set oSection = oINIFile.Sections("ODBC Data Sources")
	if( 0<>Err.number )Then
		ErrMsg( Err.description )
	else
		for each dsnItem in oSection.items  'loop through all DSNs
			sDSNSec = dsnItem.key
			if instr(1,sDSNSec,"_template")=0 then 'user dsn
				Set oDSNSec = oINIFile.Sections(dsnItem.key)
				
				strDriver1 = oDSNSec.items("Driver")
				if instr(1,strDriver1,strDriver)>0 then
					
					getItemInCol oDSNSec, "Package", sPkgTemp, ""
					if sPkgTemp<>"" then
						sPkgTemp = right(sPkgTemp,2)
						if isnumeric(sPkgTemp) then
							iPkg1 = cint(sPkgTemp)
							arPkgs(iCount) = iPkg1
						end if
						bExist = true
					end if
					iCount =iCount + 1
					if iCount>iLen then
						iLen = iLen + 10
						redim preserve arPkgs(iLen)
					end if
					if iPkg1>iPkgmax then iPkgmax = iPkg1
				end if
			end if
		next
		getPackage = true
	end if
	on error goto 0
	
	if bExist then 
		iPkg = iPkgmax + 1
	else
		iPkg = iPkgmax
	end if
	if iPkg>99 then 
		for i=0 to 99
			if isempty(arPkgs(iLen)) then
				iPkg = i
			end if
		next
	end if
	if iPkg>99 then 
		getPackage = false
	else
		arAtts(1,iAtts) = sPkg & itofullstr(iPkg, iNumDigit)
	end if
end function

'7/23/01 Joew:
'compare submitted values of attributes with current values in ini file
'arAtts -- array holding attributes name-values where arAtts(0,i) are names, arAtts(1,i) are values and arAtts(2,i) are action flags
'return: true -Same, false-changed
function ComparePkg(arSubmit, iCount, oDSNSec)
	dim i
	ComparePkg = true
	for i=0 to iCount-1
		if arSubmit(0,i)<>"Description" then
			if arSubmit(1,i)<>oDSNSec.items(arSubmit(0,i)) then
				ComparePkg = false
				exit function
			end if
		end if	
	next
end function

function replace1(s,find, replacement,start,count,compare)
	dim pos, lStart, iCount
	if start="" then 
		lStart=1
	else
		lStart = start
	end if
	if compare="" then compare=0
	if count="" then count=999999
	do while count>0
		pos = instr(lStart,s,find,compare)
		if pos>0 then
			replace=mid(s,1,pos-1) & replacement & mid(s,pos+len(find))
			lStart = pos + len(replacement) + 1
		else
			exit do
		end if
		count=count-1
	loop
end function
sub debugprt(sTitle, sText)
	Response.Write "<font color=green>" & sTitle & "</font>=" & "<font color=red>" & sText & "</font><br>"
end sub
%>