<% Option Explicit %>
<!-- #include file="inc/common.asp" -->
<!-- #include file="inc/consts.asp" -->
<!-- #include file="inc/lib.asp" -->
<%
Response.Buffer = TRUE

Dim strActionID, strServer, oInstDb, oServer, oINIFile, oSection 
Dim iErr, strErrDesc

	strActionID = Request("action")
	strServer = Request("server")
	
	Set oInstDb = CreateObject("chili.installed_db")
	Set oServer = oInstDb.Servers(strServer)
	
	select case strActionID
	case "1" ' Stop
		oServer.Stop
		
	case "2" ' Start
		oServer.Start
		IsEngineMT  oServer.Location

	case "3" ' restart
		oServer.Restart
		IsEngineMT  oServer.Location

	case "4" ' Remove server
		if UCase(Request.QueryString("btnRemove")) = "YES" Then
			oInstDb.RemoveServer( oServer.Location )
		end if
	case "5" ' Remove application

		if UCase(Request("btnRemove")) = "YES" Then
			Set oINIFile = CreateObject("chili.inifile")
			oINIFile.Open (oServer.Location & "/casp.cnfg")
			Set oSection = oINIFile.Sections("applications")
			oSection.DeleteItem(Request("app"))
			
			on error resume next
			oServer.StopWebServer
			oServer.StartWebServer
			on error goto 0
			
'			Legacy method
'			oServer.RestartWebServer

		end if

		Set oINIFile = CreateObject("chili.inifile")
		oINIFile.Open (oServer.Location & "/casp.cnfg")
		oINIFile.Sections("admin").Items("restart").value = "yes"

	case  "configapp", "addapp" ' Config/Add application 
		if UCase(Request("btnConfig")) = "SAVE" Then
			Dim strOrigApp, strNewApp, strLoc
			Set oINIFile = CreateObject("chili.inifile")

			oINIFile.Open (oServer.Location & "/casp.cnfg")
			
			Set oSection = oINIFile.Sections("applications")
			
			strOrigApp = Trim(Request("origapp"))
			strNewApp = Trim(Request("app"))
			
			strLoc = Trim(Request("location"))
			
			' error message if some field is blank
			if Len(strNewApp)=0 or Len(strLoc)=0 then
				ErrMsg ("Both fields are required.")
			end if
			
			strLoc = """" & strLoc & """"
			if strOrigApp <> strNewApp Then

				strNewApp = "/" & strNewApp
				strNewApp = Replace(strNewApp, "//", "/")

				if strNewApp="/" then
					ErrMsg ("Slash <b>" & Server.HTMLEncode("/") & "</b> is an illegal name for application.")
				end if
				
				Dim strIlChars, i
				' check for illegal characters
				strIlChars = ""
				for i=2 to len(strNewApp)
					if InStr("/\?""=", mid(strNewApp, i , 1))<>0 then 
						strIlChars = strIlChars & mid(strNewApp, i , 1)
					end if
				next
				if len(strIlChars)>0 then
					ErrMsg ("Illegal character(s) <b>" & Server.HTMLEncode(strIlChars) & "</b> found in the application name.")
				end if

				if (strNewApp<>strOrigApp) then
					' check for existense of the new app
					Dim oItem
					on error resume next
					Set oItem=oSection.Items(strNewApp)
					iErr=Err.number
					Err.Clear
					if (iErr=0) then
						ErrMsg ("Application <b>" & strNewApp & "</b> already exists.")
					end if
					on error goto 0
				end if

				oSection.DeleteItem(strOrigApp)

				oSection.AddItem strNewApp, strLoc
			else
				oSection(strOrigApp).Value = strLoc
			end if
			
			on error resume next
			oServer.StopWebServer
			oServer.StartWebServer
			on error goto 0

'			Legacy method
'			oServer.RestartWebServer

			oINIFile.Sections("admin").Items("restart").value = "yes"
		end if

	case "6" ' FP Authoring
		' Accepts second parameter fpa=0/1 1-Enable 0-disable
		oServer.EnableFPAuthoring( "1"=Request("fpa") )

	case "7" ' Web server start/stop/Restart
		' Accepts second parameter fpa=0/1 1-Enable 0-disable
		on error resume next
		if( "0"=Request("ws") )then
			oServer.StopWebServer

		elseif( "1"=Request("ws") )then
			oServer.StartWebServer

		else
			
			' ws=2 restart web server
			oServer.StopWebServer
			oServer.StartWebServer
			
		end if
		on error goto 0
	end select 

	if Err.number<>0 then
		Response.Redirect "error.asp?error=3&desc=" & Server.URLEncode(Err.description) & "&num=" & Err.number
	end if

'	on error goto 0
	
	if Request("gotopage") <> "" then
		Response.Redirect Request("gotopage")
	else
		Response.Redirect Request.ServerVariables("HTTP_REFERER")
	end if
%>
