<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>Compilation et installation d'Apache</TITLE>
</HEAD>

<!-- Background white, links blue (unvisited), navy (visited), red (active) -->
<BODY
 BGCOLOR="#FFFFFF"
 TEXT="#000000"
 LINK="#0000FF"
 VLINK="#000080"
 ALINK="#FF0000"
>
<!--#include virtual="header.html" -->

<H1 ALIGN="CENTER">Compilation et installation d'Apache 1.3</H1>

<P>Ce document d&eacute;crit la compilation et l'installation d'Apache sur
les syst&egrave;mes Unix, en employant la compilation et l'installation manuelle.
Si vous souhaitez utiliser l'interface de configuration semblable &agrave; autoconf,
il est conseill&eacute; de lire plut&ocirc;t le fichier INSTALL situ&eacute; dans la racine
des fichiers sources de la distribution d'Apache. Pour compiler et installer Apache
sur d'autres plates-formes, consultez </P>
<UL>
<LI><A HREF="windows.html">Utilisation d'Apache sur Microsoft Windows</A>
<LI><A HREF="netware.html">Utilisation d'Apache sur Novell Netware 5</A>
<LI><A HREF="mpeix.html">Utilisation d'Apache sur HP MPE/iX</A>
<LI><A HREF="unixware.html">Utilisation d'Apache sur UnixWare</A>
<LI><A HREF="readme-tpf.html">Aper&ccedil;u du portage d'Apache sur TPF</A>
</UL>

<H2>T&eacute;l&eacute;chargement d'Apache</H2>
Les informations sur la derni&egrave;re version d'Apache se trouvent sur le
site web d'Apache &agrave; l'adresse 
<A HREF="http://www.apache.org/">http://www.apache.org/</A>.  
Ce site r&eacute;unit la version actuelle, les r&eacute;centes versions
beta, ainsi que la liste des sites miroirs web et ftp anonymes.
<P>
Si vous avez t&eacute;l&eacute;charg&eacute; une distribution compos&eacute;e
des binaires, passez directement &agrave; l'<A HREF="#install">installation d'Apache</A>. 
Sinon lisez la section suivante afin de savoir comment compiler le serveur.

<H2>Compilation d'Apache</H2>

La compilation d'Apache se compose de trois &eacute;tapes : la s&eacute;lection des
<STRONG>modules</STRONG> que vous souhaitez inclure dans le serveur; 
 la cr&eacute;ation de la configuration pour votre syst&egrave;me d'exploitation; 
 la compilation les sources pour cr&eacute;er les ex&eacute;cutables.
<P>

La configuration d'Apache s'effectue dans le r&eacute;pertoire <CODE>src</CODE>
de la distribution. Entrez dans ce r&eacute;pertoire.

<OL>
 <LI>
  S&eacute;lection des modules &agrave; compiler dans Apache d&eacute;finis dans le 
	fichier <CODE>Configuration</CODE>. D&eacute;commentez les lignes correspondant
	aux modules que vous souhaitez inclure (parmi les lignes commen&ccedil;ant par
	AddModule situ&eacute;es &agrave; la fin du fichier), ou ajoutez de nouvelles
	lignes correspondant &agrave; des modules additionnels que vous avez 
	t&eacute;l&eacute;charg&eacute;s ou &eacute;crits.
	(Voir <A HREF="misc/API.html">API.html</A> comme documentation pr&eacute;liminaire
	&agrave; l'&eacute;criture de modules Apache).
	Les utilisateurs avertis peuvent commenter certains des modules actifs par d&eacute;faut
	si ils sont s&ucirc;rs qu'ils n'en ont pas besoin (il faut n&eacute;anmoins faire attention,
	car la plupart des modules actifs par d&eacute;faut sont vitaux au bon
	fonctionnement et &agrave; la s&eacute;curit&eacute; du serveur).
  <P>

	Vous pouvez &eacute;galement lire les instructions contenues dans le fichier
  <CODE>Configuration</CODE> afin de savoir si devez activer certaines lignes
  commen&ccedil;ant par <CODE>Rule</CODE>.


 <LI>
  Cr&eacute;ation de la configuration pour votre syst&egrave;me d'exploitation. 
	Normalement vous n'avez qu'&agrave; ex&eacute;cuter le script <CODE>Configure</CODE>
	comme d&eacute;crit	ci-dessous. Cependant si le script &eacute;choue ou si
	vous avez des besoins particuliers (par exemple inclure une librairie n&eacute;cessaire
	&agrave; un module optionnel) vous devrez modifier une ou plusieurs de options
	contenues dans le fichier <CODE>Configuration</CODE> :   
    <CODE>EXTRA_CFLAGS, LIBS, LDFLAGS, INCLUDES</CODE>.
  <P>

  Lancement du script <CODE>Configure</CODE> :
  <BLOCKQUOTE>
   <PRE>
    % Configure
    Using 'Configuration' as config file
     + configured for &lt;whatever&gt; platform
     + setting C compiler to &lt;whatever&gt; *
     + setting C compiler optimization-level to &lt;whatever&gt; *
     + Adding selected modules
     + doing sanity check on compiler and options
    Creating Makefile in support
    Creating Makefile in main
    Creating Makefile in os/unix
    Creating Makefile in modules/standard
   </PRE>
  </BLOCKQUOTE>

  (*: selon le fichier Configuration et votre syst&egrave;me, Configure
  peut ne pas afficher ces lignes).<P>

  Ceci cr&eacute;e un fichier Makefile qui sera utilis&eacute; lors de l'&eacute;tape 
	trois. Il cr&eacute;e &eacute;galement un fichier Makefile dans le r&eacute;pertoire 
	<CODE>support</CODE>, pour compiler les programmes optionnels d'assistance. 
  <P>

	(Si vous souhaitez maintenir diff&eacute;rentes configurations, <CODE>Configure</CODE>
  accepte une option lui disant de lire un autre fichier de configuration, comme :
	<CODE>Configure -file Configuration.ai</CODE>).
  <P>

 <LI>
  Compilation des sources. 
  Tapez : <PRE>make</PRE>
</OL>

Les modules contenus dans la distribution Apache sont ceux que nous avons 
test&eacute;s et qui ont &eacute;t&eacute;  utilis&eacute;s par plusieurs
membres de l'&eacute;quipe de d&eacute;veloppement d'Apache. Les modules
additionnels propos&eacute;s par les membres ou d'autres parties correspondant
&agrave; des besoins ou des fonctions sp&eacute;cifiques sont disponibles &agrave;
l'adresse &lt;<A HREF="http://www.apache.org/dist/contrib/modules/"
    >http://www.apache.org/dist/contrib/modules/</A>&gt;.
Des instructions sont fournies sur cette page pour lier ces modules au noyau 
d'Apache.

<H2><A NAME="install">Installation d'Apache</A></H2>

Vous devez avoir un ex&eacute;cutable appel&eacute; <CODE>httpd</CODE> dans le
r&eacute;pertoire <CODE>src</CODE>. Une distribution des binaires doit fournir
ce fichier.<P>

La prochaine &eacute;tape est d'installer le programme et de le configurer. Apache est
con&ccedil;u pour &ecirc;tre configur&eacute; et lanc&eacute; &agrave; partir
du m&ecirc;me groupe de r&eacute;pertoires o&ugrave; il a &eacute;t&eacute; 
compil&eacute;. Si vous souhaitez le lancer d'un autre emplacement, 
cr&eacute;er un r&eacute;pertoire et copiez y les r&eacute;pertoires
<CODE>conf</CODE>, <CODE>logs</CODE> et <CODE>icons</CODE>.
Dans tous les cas lisez le document 
<A HREF="misc/security_tips.html#serverroot">trucs sur la s&eacute;curit&eacute;</A>
qui d&eacute;crit comment affecter les droits sur le r&eacute;pertoire racine du serveur.<P>

L'&eacute;tape suivante est la modification des fichiers de configuration du serveur.
Cela consiste &agrave; d&eacute;finir diff&eacute;rentes
<STRONG>directives</STRONG> dans les trois fichiers centraux de configuration.
Par d&eacute;faut ces fichiers sont situ&eacute;s dans le r&eacute;pertoire 
<CODE>conf</CODE> et s'appellent <CODE>srm.conf</CODE>,
<CODE>access.conf</CODE> et <CODE>httpd.conf</CODE>. 
Pour vous aider, les m&ecirc;mes fichiers existent dans le r&eacute;pertoire
<CODE>conf</CODE> de la distribution et sont appel&eacute;s <CODE>srm.conf-dist</CODE>,
 <CODE>access.conf-dist</CODE> et <CODE>httpd.conf-dist</CODE>. 
Copiez ou renommez ces fichiers en supprimant le <CODE>-dist</CODE> pour le nouveau
nom. Ensuite &eacute;ditez chacun de ces fichiers. Lisez attentivement les 
commentaires de chacun de ces fichiers. Une mauvaise configuration de ces 
fichiers emp&ecirc;cherait votre serveur de d&eacute;marrer ou de ne pas 
&ecirc;tre s&ucirc;r. Vous devez &eacute;galement trouver dans le r&eacute;pertoire 
<CODE>conf</CODE> un fichier <CODE>mime.types</CODE>.
G&eacute;n&eacute;ralement, ce fichier n'a pas besoin d'&ecirc;tre modifi&eacute;.
<P>

Premi&egrave;rement &eacute;ditez le fichier <CODE>httpd.conf</CODE>.  
Celui ci fixe les param&egrave;tres g&eacute;n&eacute;raux du serveur : 
le num&eacute;ro de port, l'utilisateur qui l'ex&eacute;cute, etc. 
Ensuite &eacute;ditez le fichier <CODE>srm.conf</CODE>. Ce fichier d&eacute;finit
la racine de l'arborescence des documents, les fonctions sp&eacute;ciales telles
que les pages HTML dynamiques, l'analyse des imagemap, etc. Enfin, &eacute;ditez
le fichier <CODE>access.conf</CODE> pour au moins d&eacute;finir les sch&eacute;mas 
d'acc&egrave;s de base.

<P>

En plus de ces trois fichiers, le comportement du serveur peut &ecirc;tre
configur&eacute; dans chaque r&eacute;pertoire en utilisant les fichiers
<CODE>.htaccess</CODE> pour les r&eacute;pertoires acc&eacute;d&eacute;s par 
le serveur.

<H3>D&eacute;finissez l'heure du syst&egrave;me correctement !</H3>

Un bon fonctionnement d'un site web public n&eacute;cessite une heure juste, car
des &eacute;l&eacute;ments du protocole HTTP sont exprim&eacute;s en termes de date
et heure du jour.
Il est donc temps de chercher comment configurer NTP ou un autre produit
de synchronisation temporelle sur votre syst&egrave;me UNIX, ou 
un &eacute;quivalent sous NT.

<H3>D&eacute;marrage et arr&ecirc;t du serveur</H3>

Pour d&eacute;marrer le serveur, ex&eacute;cutez <CODE>httpd</CODE>. Il cherchera
le fichier <CODE>httpd.conf</CODE> &agrave; l'emplacement sp&eacute;cifi&eacute;
lors de la compilation (par d&eacute;faut 
<CODE>/usr/local/apache/conf/httpd.conf</CODE>). Si ce fichier est situ&eacute; 
autre part, vous pouvez indiquer son emplacement en utilisant l'option -f. 
Par exemple :
<PRE>
    /usr/local/apache/httpd -f /usr/local/apache/conf/httpd.conf
</PRE>

Si tout se passe bien, vous devez vous retrouver de nouveau sur l'invite de commande.
Ceci indique que le serveur est actif et s'ex&eacute;cute. Si quelque chose se 
passe mal durant l'initialisation du serveur, un message d'erreur s'affichera 
&agrave; l'&eacute;cran.

Si le serveur d&eacute;marre correctement, vous pouvez utiliser votre navigateur, 
vous connecter au serveur et lire la documentation. Si vous lancez le navigateur
&agrave; partir de la machine o&ugrave;  s'ex&eacute;cute le serveur et que vous 
utilisez le port par d&eacute;faut 80, une URL valide &agrave; taper dans votre
navigateur est : 

<PRE>
    http://localhost/
</PRE>

<P>

Notez que lors du d&eacute;marrage du serveur un certain nombre de processus 
<EM>fils</EM> sont cr&eacute;&eacute;s afin de traiter les requ&ecirc;tes.  
Si vous d&eacute;marrez le serveur en &eacute;tant root, le processus p&egrave;re
s'ex&eacute;cutera avec les droits de root, tandis que les processus fils
s'ex&eacute;cuteront avec les droits de l'utilisateur d&eacute;fini dans le 
fichier httpd.conf.

<P>

Si au lancement de <CODE>httpd</CODE> celui ci indique qu'il n'arrive pas &agrave; 
s'attacher &agrave; une adresse, cela signifie soit qu'un autre processus
s'ex&eacute;cute d&eacute;j&agrave; en utilisant le num&eacute;ro de port
d&eacute;fini dans la configuration d'Apache, soit que vous essayez de lancer httpd
en tant qu'utilisateur normal et que vous essayez d'utiliser un port 
inf&eacute;rieur &agrave; 1024 (comme le port 80 par exemple). 
<P>

Si le serveur ne s'ex&eacute;cute pas, lisez le message affich&eacute; quand vous
lancez httpd. Vous devez &eacute;galement v&eacute;rifier le fichier
error_log pour plus d'informations (dans la configuration par d&eacute;faut 
ce fichier est situ&eacute; dans le fichier <CODE>error_log</CODE> du 
r&eacute;pertoire <CODE>logs</CODE>).
<P>

Si vous voulez que votre serveur continue &agrave; s'ex&eacute;cuter apr&egrave;s
une relance du syst&egrave;me, vous devez ajouter un appel &agrave; <CODE>httpd</CODE>
dans vos fichiers de d&eacute;marrage du syst&egrave;me (typiquement <CODE>rc.local</CODE> 
ou un fichier dans un r&eacute;pertoire <CODE>rc.<EM>N</EM></CODE>). 
Ceci lancera le serveur Apache avec les droits de root.
Avant de le faire, v&eacute;rifiez que votre serveur est correctement configur&eacute;
au niveau de la s&eacute;curit&eacute; et des restrictions d'acc&egrave;s. 

<P>

Pour arr&ecirc;ter Apache, envoyez au processus parent un signal TERM.
Le PID de ce processus est &eacute;crit dans le fichier <CODE>httpd.pid</CODE>
situ&eacute; dans le r&eacute;pertoire <CODE>logs</CODE> (&agrave; moins qu'Apache
soit configur&eacute; autrement). N'essayez pas de supprimer les processus fils car
d'autres seront cr&eacute;&eacute;s par le processus p&egrave;re. Une commande
typique pour arr&ecirc;ter le serveur est :

<PRE>
    kill -TERM `cat /usr/local/apache/logs/httpd.pid`
</PRE>

<P>

Pour plus d'information sur les options de la ligne de commande, sur les
fichiers de configuration et les fichiers de trace, voir
<A HREF="invoking.html">D&eacute;marrage d'Apache</A>. Pour un guide de 
r&eacute;f&eacute;rence de toutes les directives Apache autoris&eacute;es par
les modules distribu&eacute;s, voir les
<A HREF="mod/directives.html">directives Apache </A>.

<H2>Compilation des programmes d'assistance</H2>

En plus du serveur <CODE>httpd</CODE> qui est compil&eacute; et configur&eacute; comme ci dessus,
Apache inclut un certain nombre de programmes d'assistance. 
Ceux ci ne sont pas compil&eacute;s par d&eacute;faut. Les programmes d'assistance
sont situ&eacute;s dans le r&eacute;pertoire <CODE>support</CODE> de la distribution.
Pour les compiler, allez dans ce r&eacute;pertoire et tapez : 
<PRE>
    make
</PRE>

<!--#include virtual="footer.html" -->
</BODY>
</HTML>
